; 3D View v2.5d Key Generator.
; By CrackZ (27/09/98).
;
; Use tasm /zi 3dview.asm and then tlink /v 3dview.

.MODEL SMALL
.STACK 100h
.386

.DATA

input   DB 0ch,0
serial  DB 20h dup ('$')                      
fill	DB 0Ch dup ('x')
prompt  DB 'Input your Program Serial # (AFY-xxx-xxx) : ','$'
done    DB 'Your KeyCode is: ','$'
lf      DB 0ah,0dh,'$'
logo    DB 0ah,0dh, '------------------------------',0ah,0dh
	DB          '  3D View v2.5d Key Generator ',0ah,0dh
        DB          '     by CrackZ                ',0ah,0dh
	DB          '------------------------------',0ah,0dh
	DB 0ah,0dh,'$'
        
.CODE

START:	MOV	AX,@DATA
	MOV	DS,AX
	MOV	ES,AX			;Point DS/ES @DATA.
	LEA	EDX,[logo]
	MOV	AH,09h
	INT	21h			;Display Logo.
	LEA	EDX,[prompt]
	MOV	AH,09h
	INT	21h			;Prompt.
	LEA	EDX,[input]		 
	MOV	AH,0Ah
	INT	21h			;Get serial #.
	LEA	EDX,[lf]
	MOV	AH,09h
	INT	21h			;Linefeed for aesthetics.
	
	CMP	BYTE PTR [input+1],00	;Check Serial # was entered.
	JZ	endprg
	LEA	ECX,input+2		;Name pointed too by ECX.
	MOV	EDI,0Ch

fixser:	LEA	EAX, [fill]		;Fill.
	ADD	ECX,04h			;Point at 5th char of Serial #.
	XOR	EBX,EBX			;Clear for copy control loop.
	XOR	ESI,ESI
	XOR	EDX,EDX			;Clear registers.

first3:	MOV	DL, BYTE PTR [ECX]
	MOV	[EAX],DL
	INC	ECX
	INC	EAX
	INC	ESI
	CMP	ESI,03h
	JNZ	first3
	INC	ECX			;Ready for @3to6.
	XOR	ESI,ESI			;Reset loop.

@3to6:	MOV	DL, BYTE PTR [ECX]
	MOV	[EAX],DL
	INC	ECX
	INC	EAX
	INC	ESI
	CMP	ESI,03h
	JNZ	@3to6
	XOR	ESI,ESI			;Reset loop.
	SUB	ECX,07h			;Fixup ECX.
	INC	EBX			;Increase copy control loop.
	CMP	EBX,02h
	JNZ	first3			;Copy again.
	SUB	EAX,0ch			;Fixup EAX.
	MOV	ECX,EAX

;This small section of code fixes all of the registers and makes the minor 
;required modification to the serial #.

inits:	MOV	ESI,07h			;Start ESI at 7.
	MOV	EBX,09h			;EBX is 9.
	XOR	EAX,EAX
	XOR	EDX,EDX			;Clear registers.
	MOV	AL, BYTE PTR [ECX+09]	;10th character.
	MOV	[ECX+02],AL		;Move it to the 3rd.
	XOR	AL,AL			;Fix complete.

;Now we can proceed with the calculation loop.

calc:	MOV	DL, BYTE PTR [ECX]
	MOV	EAX,ESI
	IMUL	EAX,EDX
	LEA	EAX, [EAX+4*EAX]
	CDQ
	IDIV	EBX
	ADD	DL,30h
	MOV	BYTE PTR [ECX],DL
	INC	ECX			;Next number.
	INC	ESI			;Increment value of ESI.
	DEC	EDI			;Decrement loop.
	TEST	EDI,EDI
	JNZ	calc
	SUB	ECX,0ch			;Fixup ECX.
	MOV	EDI,ECX
	MOV	EAX,0ch
	MOV	BYTE PTR [EDI+EAX],'$'	;Paste end character KeyCode.
	LEA	EDX,[done]
	MOV	AH,09h
	INT	21h			;"Your KeyCode is".
	LEA	EDX,[EDI]
	MOV	AH,09h
	INT	21h			;Print registration code.

endprg:
	LEA	EDX,[lf]
	MOV	AH,09h
	INT	21h
	MOV	AX,4C00h
	INT	21h
	
END START